-- V2D - 12549 Messaging for Leave Creation Event

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Leave Management');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'LEAVE_APPROVE_WORK_HAND_OVER');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='LEAVE_APPROVE_WORK_HAND_OVER');
INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'LEAVE_WORK_HAND_OVER', 'Leave Work Handover', 'SYSTEM', 0, 0, 0, 0, 1, 0, 0, 'Leave Work Handover');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'LEAVE_WORK_HAND_OVER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'LEAVE_WORK_HAND_OVER_RECIPIENT', 'SQL');

-- SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
-- INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'BULK_DOCUMENT_DOWNLOAD_TDP', 'CB');


-- Create Recipient Type 

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_WORK_HAND_OVER_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'LEAVE_WORK_HAND_OVER_RECIPIENT');


-- SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
-- INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) 
-- VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,NULL,NULL);


-- Link Template data provider to message category

-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='LEAVE_APPROVE_WORK_HAND_OVER');
-- SET @templatedtproviderId=(SELECT MAX(id) FROM template_dtprovider);
-- INSERT INTO `template_dtprovider`(`id`,`msgSubCategoryId`,`dataProviderId`,`dataProviderName`) VALUES (@templatedtproviderId+1,@msgSubCategoryId,@dtproviderId,'BULK_DOCUMENT_DOWNLOAD_TDP');


-- The under sql code gives for the user distribution list ,this information can be fetched

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_WORK_HAND_OVER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='LEAVE_WORK_HAND_OVER_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);



-- Setting the query for the Applicant distribution list

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_WORK_HAND_OVER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T2.id AS USER_ID   
FROM
    hr_emp_leave_request AS T1
        LEFT JOIN
    hr_emp_leave_request_handover_user AS T2 ON T2.hrEmpLeaveRequestId = T1.id
WHERE
    T1.id IN (namedParams) AND T1.status = 'APPROVED'",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='LEAVE_WORK_HAND_OVER_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T6.id AS ID,
    requester.emailId AS EMAIL_ID,
    requester.mobileNumber AS MOBILE_NO,
    requester.mobileCountryCode AS MOBILE_CODE,
    requester.printName AS PRINT_NAME,
    requester.firstName AS FIRST_NAME,
    requester.lastName AS LAST_NAME,
    reqUser.code AS CODE,
    T5.salutationName AS SALUTATION_NAME,
    T10.printName AS REQ_PRINT_NAME,
    T11.code AS REQ_CODE,
    T8.academyName AS ACADEMY_NAME,
    T8.locationName AS LOCATION_NAME,
    T8.displayName AS ACADEMY_NAME_LOCATION,
    T8.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(T1.fromDate, '%d-%m-%Y') AS FROM_DATE,
    DATE_FORMAT(T1.toDate, '%d-%m-%Y') AS TO_DATE,
    (CASE WHEN T8.logoUrl IS NULL AND org.orgUrl IS NOT NULL
        THEN CONCAT(org.orgUrl,'/', 'emailer/images/logo_default_image.png')
        WHEN T8.logoUrl IS NULL AND org.orgUrl IS NULL
        THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T8.logoUrl) END) AS LOGO_URL,
    (CASE WHEN T8.headerUrl IS NOT NULL AND org.orgUrl IS NOT NULL
        THEN CONCAT(org.orgUrl, '/', T8.headerUrl) ELSE NULL END) AS HEADER_URL,
    (CASE WHEN T8.footerUrl IS NOT NULL AND org.orgUrl IS NOT NULL
        THEN CONCAT(org.orgUrl, '/', T8.footerUrl)
        ELSE NULL END) AS FOOTER_URL
FROM
    hr_emp_leave_request_handover_user AS T6
        LEFT JOIN
    hr_emp_leave_request AS T1 ON T1.id = T6.hrEmpLeaveRequestId
        LEFT JOIN
    staffs AS T3 ON T3.userId = T6.userId
        LEFT JOIN
    persons AS requester ON requester.id = T3.personId
        LEFT JOIN
    salutations AS T5 ON T5.id = requester.salutationId
        LEFT JOIN
    users AS reqUser ON reqUser.id = T3.userId
        LEFT JOIN
    academy_location T8 ON T8.id = T1.academyLocationId
        LEFT JOIN
    staffs AS T9 ON T9.userId = T1.requestUserId
        LEFT JOIN
    persons AS T10 ON T10.id = T9.personId
        LEFT JOIN
    users AS T11 ON T11.id = T9.userId
		LEFT JOIN
    organizations org ON org.id = (SELECT MAX(org.id))
WHERE
    T6.id IN (namedParams)",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "printName",
            "resultKey": "PRINT_NAME",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "middleName",
            "resultKey": "MIDDLE_NAME",
            "displayCode": "",
            "displayOrder": 2
        },        
        {
            "id": 4,
            "value": "lastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 3
        },
		{
            "id": 5,
            "value": "code",
            "resultKey": "CODE",
            "displayCode": "",
            "displayOrder": 4
        },
		{
            "id": 6,
            "value": "FROM_DATE",
            "resultKey": "FROM_DATE",
            "displayCode": "",
            "displayOrder": 5
        },
		{
            "id": 7,
            "value": "TO_DATE",
            "resultKey": "TO_DATE",
            "displayCode": "",
            "displayOrder": 6
        },
		{
            "id": 8,
            "value": "salutationName",
            "resultKey": "SALUTATION_NAME",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 9
        },        
        {
            "id": 11,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 10
        },
		{
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        },
		{
            "id": 13,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 12
        },
		{
            "id": 14,
            "value": "locationName",
            "resultKey": "LOCATION_NAME",
            "displayCode": "",
            "displayOrder": 13
        },
		{
            "id": 15,
            "value": "id",
            "resultKey": "ACADEMY_LOCATION_ID",
            "displayCode": "",
            "displayOrder": 14
        },
		{
            "id": 16,
            "value": "printName",
            "resultKey": "REQ_PRINT_NAME",
            "displayCode": "",
            "displayOrder": 15
        },
		{
            "id": 17,
            "value": "code",
            "resultKey": "REQ_CODE",
            "displayCode": "",
            "displayOrder": 16
        }
    ]
}');





-- Setting data in cb_dtprovider for the USER_UPDATE_LOGIN_CREDENTIAL_TDP ADDED

-- SET @cbdtproviderId=(SELECT MAX(id) FROM `cb_dtprovider`);
-- SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='BULK_DOCUMENT_DOWNLOAD_TDP');
-- insert  into `cb_dtprovider`(`id`,`dataProviderId`,`searchConfigCode`,`searchResultViewCode`) values (@cbdtproviderId+1, @dtproviderId,'BULK_DOCUMENT_DOWNLOAD_TDP','BULK_DOCUMENT_DOWNLOAD_TDP');




SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='LEAVE_WORK_HAND_OVER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='LEAVE_APPROVE_WORK_HAND_OVER');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='LEAVE_WORK_HAND_OVER_RECIPIENT');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications');


INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Employee Work Handover',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,NULL,NULL,'Employee Work Handover',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Work Handover Information','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello $recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> This is to inform you that $recipientData[&quot;REQ_CODE&quot;]/$recipientData[&quot;REQ_PRINT_NAME&quot;] will be on leave from $recipientData[&quot;FROM_DATE&quot;] till $recipientData[&quot;TO_DATE&quot;], and has opted you for the work handover. </span></span></p>
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thanks!<br /></span></span></p>            				
			</td>
		</tr>
		
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'4','Work Handover Information','<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello $recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;"> This is to inform you that $recipientData[&quot;REQ_CODE&quot;]/$recipientData[&quot;REQ_PRINT_NAME&quot;] will be on leave from $recipientData[&quot;FROM_DATE&quot;] till $recipientData[&quot;TO_DATE&quot;], and has opted you for the work handover. </span></span></p>
			<p><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Thanks!<br /></span></span></p>            				
			</td>
		</tr>
		
	</tbody>
</table>
</body>
</html>');


INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Hello $recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;],
This is to inform you that $recipientData[&quot;REQ_CODE&quot;]/$recipientData[&quot;REQ_PRINT_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;] will be on leave from $recipientData[&quot;FROM_DATE&quot;] till $recipientData[&quot;TO_DATE&quot;], and has opted you for the work handover.');




-- End Messaging for LEAVE_WORK_HAND_OVER Event
